
(defmeth reliability-model-object-proto :create-data 
  (&key (dialog nil)
        (scale t)
        (scale-norm nil)
        (scale-t nil)
        (scale-if nil)
        (scale-norm-if nil)
        (scale-t-if nil)
        (scale-mean nil)
        (scale-deviat nil)
        (scale-estimated nil)
        (scale-error nil)
        (scale-estimated-CI nil)
        (n-tiles nil)
        (n-tiles4 nil)
        )
  (if (not (eq current-object self)) (setcm self)) 
  (let (
        (creator (send *desktop* :selected-icon))
        (desires (list (list (if scale 0) 
                             (if scale-norm 1)
                             (if scale-t 2)
                             (if scale-if 3) 
                             (if scale-norm-if 4)
                             (if scale-t-if 5)
                             (if scale-mean 6)
(if scale-deviat 7)
                             (if scale-estimated 8)
                             (if scale-error 9)
                             (if scale-estimated-CI 10)
                             (if n-tiles 11)
                             (if n-tiles4 12)
                             )))
        )
    (cond 
      (dialog
       (setf desires 
             (choose-subset-dialog "Choose Desired Data Objects"
                                   '("Total Score"
                                            "Normalized Z Score"
                                            "Normalized T Score"
                                            "Total Score if item deleted"
                                            "Normalized Z Score if Item deleted"
                                            "Normalized T Score if Item deleted "
                                            "Mean Score = Total Score/number of items"
                                            "Deviation Score = Total Score - Test Mean"
                                            "Estimated Score"
                                            "Confidence Interval for Observed Score"
                                            "Confidence Interval for Estimated Score"
                                            "N-tiles=2 (Median)"
                                            "N-tiles=4 (Q1,Q2,Q3)"
                                            )
                                   :initial (select desires '0)
                                   )
             )
       )
      (t
       (setf desires 
             (list (list (if scale 0)
                         (if scale-norm 1)
                         (if scale-t 2)
                         (if scale-if 3)
                         (if scale-norm-if 4)
                         (if scale-t-if 5)
                         (if scale-mean 6)
                         (if scale-deviat 7)
                         (IF scale-estimated 8)
                         (if scale-error 9)
                         (if scale-estimated-CI 10)
                         (if n-tiles 11) 
                         (if n-tiles4 12) 
                         )))))
    (when desires
          (when (member '0 (select desires 0))
                (send current-model :rel-scale-data-object creator))
          (when (member '1 (select desires 0))
                (send current-model :rel-scale-norm-data-object  creator))
           (when (member '2 (select desires 0))
                (send current-model :rel-scale-t-data-object  creator))
          (when (member '3 (select desires 0))
                (send current-model :rel-scale-if-data-object  creator))
          (when (member '4 (select desires 0))
                (send current-model :rel-scale-norm-if-data-object  creator))
          (when (member '5 (select desires 0))
                (send current-model :rel-scale-t-if-data-object creator))
          (when (member '6 (select desires 0))
                (send current-model :rel-scale-item-mean-data-object creator))
  (when (member '7 (select desires 0))
                (send current-model :rel-scale-item-deviat-data-object creator))
          (when (member '8 (select desires 0))
                (send current-model :rel-scale-estimated-data-object creator))
          (when (member '9 (select desires 0))
                (send current-model :rel-scale-error-data-object creator))
          (when (member '10 (select desires 0))
                (send current-model :rel-scale-estimated-CI-data-object creator))
 (when (member '11 (select desires 0))
                (send current-model :rel-scale-ntiles2-data-object creator))
          (when (member '12 (select desires 0))
                (send current-model :rel-scale-ntiles4-data-object creator))

                    )
    (not (not desires))))



;0
(defmeth reliability-model-object-proto  :rel-scale-data-object (creator)
  (data (strcat "Total Score-" (send self :name))
   :created creator
   :creator-object self
   :title (strcat "Tot-Score-for " (send self :title))
   :data  (combine (send self :scale))
   :variables (List "Total-Score")
          :labels (send self :labels)
          :types (list "Numeric")
    ) 
  )


(defmeth reliability-model-object-proto  :rel-scale-if-data-object (creator)
  (data (strcat "Total-score-if-" (send self :name))
   :created creator
   :creator-object self
   :title (strcat "Total Score if item deleted for " (send self :title))
   :data (combine (column-list (make-array (list (send self :n-items) (send self :nobs)) :initial-contents (combine (send self :scale-if)))))
   :variables (mapcar #'(lambda (x) (format nil "If~a" x)) (send self :variables))
          :labels (send self :labels)
          :types (repeat "Numeric" (iseq (send self :n-items)))
        )
  )


(defmeth reliability-model-object-proto  :rel-scale-norm-data-object (creator)
  (data (strcat "Z Score-" (send self :name))
   :created creator
   :creator-object self
   :title (strcat "Z Score for " (send self :title))
   :data  (combine (standardize (send self :scale)))
   :variables (List "Z Score")
          :labels (send self :labels)
          :types (list "Numeric")

        )
  )


(defmeth reliability-model-object-proto  :rel-scale-norm-if-data-object (creator)
  (data (strcat "Z Score if-" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "Z Score if" (send self :title))
   :data  (combine (column-list (make-array (list (send self :n-items) (send self :nobs)) :initial-contents (combine (mapcar #'standardize (send self :scale-if))))))
   :variables (mapcar #'(lambda (x) (format nil "If~a" x)) (send self :variables))
          :labels (send self :labels)
          :types (repeat "Numeric" (iseq (send self :n-items)))
        )
  )


(defmeth reliability-model-object-proto  :rel-scale-t-data-object (creator)
  (data (strcat "Normalized T Score-" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "Normalized T Score" (send self :title))
   :data (mapcar #'(lambda (x) (+ 50 (* x 10))) (combine (standardize (send self :scale))))
   :variables (list "T-Score")
          :labels (send self :labels)
          :types (list "Numeric")
        )
  )


(defmeth reliability-model-object-proto  :rel-scale-t-if-data-object (creator)
  (data (strcat "T Score if item deleted-" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "T Score if item deleted" (send self :title))
   :data  (combine (column-list (make-array (list (send self :n-items) (send self :nobs)) :initial-contents (combine (mapcar #'(lambda (x) (+ 50 (* x 10))) (combine (mapcar #'standardize (send self :scale-if))))))))

   :variables (mapcar #'(lambda (x) (format nil "If~a" x)) (send self :variables))
          :labels (send self :labels)
          :types (repeat "Numeric" (iseq (send self :n-items)))
        )
  )


(defmeth reliability-model-object-proto :rel-scale-item-mean-data-object (creator)
  (data (strcat "Mean Score-" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "Mean Score" (send self :title))
   :data   (combine (/ (send self :scale) (send self :n-items)))
   :variables (list "Mean-Score")
          :labels (send self :labels)
          :types (list "Numeric")
        )
  )

;*****7
(defmeth reliability-model-object-proto :rel-scale-item-deviat-data-object (creator)
  (data (strcat "Deviation Score-" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "Deviation Score" (send self :title))
   :data   (combine (- (send self :scale) ( mean (send self :scale))))
   :variables (list "Dev-Score")
          :labels (send self :labels)
          :types (list "Numeric")
        )
  )


;****11***N-tiles-2
(defmeth reliability-model-object-proto :rel-scale-ntiles2-data-object  (creator)
  (data (strcat "2-tiles" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "2-tiles" (send self :title))
   :data   (mapcar #'(lambda (x) 
                       (if (< x (median (send self :scale))) 1 2)) (send self :scale))
   :variables (list "2-tiles")
          :labels (send self :labels)
          :types (list "Numeric")
        )
  )

;****12***N-tiles-4

(defmeth reliability-model-object-proto :rel-scale-ntiles4-data-object  (creator)
  (data (strcat "4-tiles" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "4-tiles" (send self :title))
   :data   (mapcar #'(lambda (x) 
                   (cond
                     (  (< x (quantile (send self :scale) .25))  1)
                     (  (and (>= x (quantile (send self :scale) .25)) (< x (quantile (send self :scale) .5))) 2)
                     (  (and (>= x (quantile (send self :scale) .50)) (< x (quantile (send self :scale) .75))) 3)
                     (  (>= x (quantile (send self :scale) .75))  4)
                     )) (send self :scale))

   :variables (list "4-tiles")
          :labels (send self :labels)
          :types (list "Numeric")
        )
  )


;***8***
(defmeth reliability-model-object-proto :rel-scale-estimated-data-object (creator)

(setf text-std (send edit-text-item-proto :new (format nil "~,3g" (send self :scale-std)) :text-length 5))
(setf text-mean (send edit-text-item-proto :new (format nil "~,3g" (send self :scale-mean)) :text-length 5))
(setf text-rel (send edit-text-item-proto :new (format nil "~,3g" (send self :alfa)) :text-length 5))
(setf text-level (send edit-text-item-proto :new ".95" :text-length 5))

(setf OK (send modal-button-proto :new "Ok"
               :action
               #'(lambda ()
                   (let (
                         (dialog (send ok :dialog))
                         )
             (setf std  (read-from-string (send text-std :text)))
             (setf mean  (read-from-string (send text-mean :text)))
             (setf rel  (read-from-string (send text-rel :text))); coef.fiab
             (setf level (read-from-string (send text-level :text)));niv. de confianza
             (setf SEM (* std (sqrt (- 1 rel)))); error standard

             (setf level-to-z  (normal-quant (/  (- 1 level ) 2)))

             (setf interval (* level-to-z SEM)); 
             (setf estimated-score (+ mean (* rel (- (send self :scale) mean))))           
                     ))))

(setf cancel (send modal-button-proto :new "Cancel"
               :action
               #'(lambda ()
                   (let (
                         (dialog (send cancel :dialog))
                         )
                    (send dialog :modal-dialog-return nil) ))))

(setf dialog
      (send modal-dialog-proto :new  
            (list 
             (list "Test Standard Deviation      "text-std)
             (list "Test Mean                    "text-mean)
             (list "Reliability (Alpha by default)"text-rel)
             ;(list "Confidence Interval Level     "text-level)
             (list ok cancel ))
			:default-button ok :title "Options for Estimated Score"
            )
      )
(setf result (send dialog :modal-dialog))

  (data (strcat "Estimated-" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "ES" (send self :title))
   :data  (combine (column-list (make-array (list 1 (send self :nobs)) :initial-contents (combine estimated-score ))))
   :variables (list "Est-score")
          :labels (send self :labels)
          :types (list "Numeric")
        )
  )
                         

;***9***
(defmeth reliability-model-object-proto :rel-scale-error-data-object (creator)

(setf text-std (send edit-text-item-proto :new (format nil "~,3g" (send self :scale-std)) :text-length 5))
(setf text-rel (send edit-text-item-proto :new (format nil "~,3g" (send self :alfa)) :text-length 5))
(setf text-level (send edit-text-item-proto :new ".95" :text-length 5))

(setf OK (send modal-button-proto :new "Ok"
               :action
               #'(lambda ()
                   (let (
                         (dialog (send ok :dialog))
                         )
             (setf std  (read-from-string (send text-std :text)))
             (setf rel  (read-from-string (send text-rel :text))); coef.fiab
             (setf level (read-from-string (send text-level :text)));niv. de confianza
             (setf SEM (* std (sqrt (- 1 rel)))); error standard
             (setf level-to-z  (normal-quant (+ level (/  (- 1 level ) 2))))
             (setf interval (* level-to-z SEM)); max valor del error dado un niv. de conf.
             (setf max-data (map-elements #'+ (send self :scale) interval ))
             (setf min-data (map-elements #'- (send self :scale) interval))           
                     ))))

(setf cancel (send modal-button-proto :new "Cancel"
               :action
               #'(lambda ()
                   (let (
                         (dialog (send cancel :dialog))
                         )
                    (send dialog :modal-dialog-return nil) ))))

(setf dialog
      (send modal-dialog-proto :new  
            (list 
             (list "Test Standard Deviation       "text-std)
             (list "Reliability (Alpha by default)"text-rel)
             (list "Confidence Interval Level     "text-level)
             (list ok cancel ))
			:default-button ok :title "CI options for Observed Scores"
            )
      )
(setf result (send dialog :modal-dialog))

  (data (strcat "CI-" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "CI" (send self :title))
   :data  (combine (column-list (make-array (list 3 (send self :nobs)) :initial-contents (combine min-data (send self :scale) max-data))))
   :variables (list "Min" "Test-Score" "Max")
          :labels (send self :labels)
          :types (list "Numeric" "Numeric" "Numeric")
        )
  )
  
;***10***
(defmeth reliability-model-object-proto :rel-scale-estimated-CI-data-object (creator)

(setf text-std (send edit-text-item-proto :new (format nil "~,3g" (send self :scale-std)) :text-length 5))
(setf text-mean (send edit-text-item-proto :new (format nil "~,3g" (send self :scale-mean)) :text-length 5))
(setf text-rel (send edit-text-item-proto :new (format nil "~,3g" (send self :alfa)) :text-length 5))
(setf text-level (send edit-text-item-proto :new ".95" :text-length 5))

(setf OK (send modal-button-proto :new "Ok"
               :action
               #'(lambda ()
                   (let (
                         (dialog (send ok :dialog))
                         )
             (setf std  (read-from-string (send text-std :text)))
             (setf mean  (read-from-string (send text-mean :text)))
             (setf rel  (read-from-string (send text-rel :text))); coef.fiab
             (setf level (read-from-string (send text-level :text)));niv. de confianza
             (setf SEM (* std (sqrt (- 1 rel)))); error standard
              (setf level-to-z  (normal-quant (+ level (/  (- 1 level ) 2))))
             (setf interval (* level-to-z SEM)); max valor del error dado un niv. de conf.
             (setf estimated-score (+ mean (* rel (- (send self :scale) mean))))
             (setf max-data (map-elements #'+ estimated-score interval ))
             (setf min-data (map-elements #'- estimated-score interval))           
                     ))))

(setf cancel (send modal-button-proto :new "Cancel"
               :action
               #'(lambda ()
                   (let (
                         (dialog (send cancel :dialog))
                         )
                    (send dialog :modal-dialog-return nil) ))))

(setf dialog
      (send modal-dialog-proto :new  
            (list 
             (list "Test Standard Deviation       "text-std)
             (list "Test Mean                     "text-mean)
             (list "Reliability (Alpha by default)"text-rel)
             (list "Confidence Interval Level     "text-level)
             (list ok cancel ))
			:default-button ok :title "CI options for Estimated Score"
            )
      )
(setf result (send dialog :modal-dialog))

  (data (strcat "CI-" (send self :name))
     :created creator
   :creator-object self
   :title (strcat "CI" (send self :title))
   :data  (combine (column-list (make-array (list 4 (send self :nobs)) :initial-contents (combine min-data estimated-score max-data (send self :scale) ))))
   :variables (list "Min" "Estimated" "Max" "Test-Score")
          :labels (send self :labels)
          :types (list "Numeric" "Numeric" "Numeric" "Numeric")
        )
  )
                                    
